	subroutine OUT(iout, idbg, ipost, Nn, Np, Ns, NnNd, ldw, &
			time, Nc, C, T, w, work, In, Ao, &
			lastQc1, lastQd1, lastF1, lastQc2, lastQd2, lastF2, &
			vQc1, vQd1, vF1, rQc1, rQd1, rF1, cQc1, cQd1, cF1, &	
			vQc2, vQd2, vF2, rQc2, rQd2, rF2, cQc2, cQd2, cF2)	
! write solver output, C, T and nodal fluxes

	implicit none
	integer iout, idbg, ipost
	integer Nn, Np, Ns, ldw, NnNd	! array parameters
	integer lastQc1, lastQd1, lastF1, lastQc2, lastQd2, lastF2
	integer rQc1(Nn+1), rQd1(Nn+1), rF1(Nn+1)	! global  arrays (compact rows)
	integer rQc2(Nn+1), rQd2(Nn+1), rF2(Nn+1)	! global  arrays (compact rows)
	integer cQc1(NnNd), cQd1(NnNd), cF1(NnNd)	! global  arrays (compact columns)
	integer cQc2(NnNd), cQd2(NnNd), cF2(NnNd)	! global  arrays (compact columns)
	real*8 time
	real*8 C   (Nn,Ns), T   (Nn,Ns)		! global  arrays
	real*8 vQc1(NnNd), vQd1(NnNd), vF1(NnNd)! global  arrays (compact values)
	real*8 vQc2(NnNd), vQd2(NnNd), vF2(NnNd)! global  arrays (compact values)
	real*8 w(Nn,Ns), work(ldw)		! work arrays
	real*8 In(Nn,Ns,0:Np)			! convolution array M*C
	real*8 Ao(Nn)				! nodal averaged array
	integer Nc

	integer i, p, ii, jj, s

	write(idbg,'(a)') ' --- OUT ---'	! ### TEMPORARY ###

	Nc = Nc + 1		! counter for Gmsh

! output C
	do s = 1, Ns
	  write(ipost,'(a)') '$NodeData'
	  write(ipost,'(i10, a)') 1, '	// number-of-string-tags'
	  write(ipost,'(a2,i1,a)') '"C', s , '"	// < "string-tag" > ...'
	  write(ipost,'(i10, a)') 1, '	// number-of-real-tags'
	  write(ipost,'(g, a)') time, '	// < real-tag > ... time'
	  write(ipost,'(i10, a)') 3, '	// number-of-integer-tags'
	  write(ipost,'(i10, a)') Nc, '	// step #'
	  write(ipost,'(i10, a)') 1, '	// number of components'
	  write(ipost,'(i10, a)') Nn, '	// number of nodes'
	do i = 1, Nn
	    write(ipost,'(i10, 3g)') i,  C(i,s)
	enddo	!i
	  write(ipost,'(a)') '// node-number value ...'
	  write(ipost,'(a)') '$EndNodeData'
	  write(ipost,*)
	enddo	! s
! output T
	do s = 1, Ns
	  write(ipost,'(a)') '$NodeData'
	  write(ipost,'(i10, a)') 1, '	// number-of-string-tags'
	  write(ipost,'(a2,i1,a)') '"T', s , '"	// < "string-tag" > ...'
	  write(ipost,'(i10, a)') 1, '	// number-of-real-tags'
	  write(ipost,'(g, a)') time, '	// < real-tag > ... time'
	  write(ipost,'(i10, a)') 3, '	// number-of-integer-tags'
	  write(ipost,'(i10, a)') Nc, '	// step #'
	  write(ipost,'(i10, a)') 1, '	// number of components'
	  write(ipost,'(i10, a)') Nn, '	// number of nodes'
	  do i = 1, Nn
	    write(ipost,'(i10, 3g)') i,  T(i,s)
	  enddo	! i
	  write(ipost,'(a)') '// node-number value ...'
	  write(ipost,'(a)') '$EndNodeData'
	  write(ipost,*)
	enddo	! s
! nodal dispersion flux, qc
! compute and write {qc} = [Qc]{C}
	do s = 1, Ns
	  write(ipost,'(a)') '$NodeData'
	  write(ipost,'(i10, a)') 1, '	// number-of-string-tags'
	  write(ipost,'(a3,i1,a)') '"qc', s , '" // < "string-tag" > ...'
	  write(ipost,'(i10, a)') 1, '	// number-of-real-tags'
	  write(ipost,'(g, a)') time, '	// < real-tag > ... time'
	  write(ipost,'(i10, a)') 3, '	// number-of-integer-tags'
	  write(ipost,'(i10, a)') Nc, '	// step #'
	  write(ipost,'(i10, a)') 3, '	// number of components'
	  write(ipost,'(i10, a)') Nn, '	// number of nodes'
! compute {work(   1:  Nn)} = [Qc1]{C} using AMUX from SPARSKIT2
! compute {work(Nn+1:2*Nn)} = [Qc2]{C} using AMUX from SPARSKIT2
	  call AMUX(Nn, C(1,s), work(   1), vQc1, cQc1, rQc1)	! {work(   1:  Nn)} = [Qc1]{C}
	  call AMUX(Nn, C(1,s), work(Nn+1), vQc2, cQc2, rQc2)	! {work(Nn+1:2*Nn)} = [Qc2]{C}
	  do ii = 1, Nn
	    write(ipost,'(i10, 3g)') ii, work(ii), work(Nn+ii), 0.
	  enddo	! ii
	  write(ipost,'(a)') '// node-number value ...'
	  write(ipost,'(a)') '$EndNodeData'
	  write(ipost,*)
	enddo	! s
! nodal dispersion flux, qd
! compute and write {qd} = [Qd]{C}
	do s = 1, Ns
	  write(ipost,'(a)') '$NodeData'
	  write(ipost,'(i10, a)') 1, '	// number-of-string-tags'
	  write(ipost,'(a3,i1,a)') '"qd', s , '" // < "string-tag" > ...'
	  write(ipost,'(i10, a)') 1, '	// number-of-real-tags'
	  write(ipost,'(g, a)') time, '	// < real-tag > ... time'
	  write(ipost,'(i10, a)') 3, '	// number-of-integer-tags'
	  write(ipost,'(i10, a)') Nc, '	// step #'
	  write(ipost,'(i10, a)') 3, '	// number of components'
	  write(ipost,'(i10, a)') Nn, '	// number of nodes'
! compute {work(   1:  Nn)} = [Qd1]{C} using AMUX from SPARSKIT2
! compute {work(Nn+1:2*Nn)} = [Qd2]{C} using AMUX from SPARSKIT2
	  call AMUX(Nn, C(1,s), work(   1), vQd1, cQd1, rQd1)	! {work(   1:  Nn)} = [Qd1]{C}
	  call AMUX(Nn, C(1,s), work(Nn+1), vQd2, cQd2, rQd2)	! {work(Nn+1:2*Nn)} = [Qd2]{C}
	  do ii = 1, Nn
	    write(ipost,'(i10, 3g)') ii, work(ii), work(Nn+ii), 0.
	  enddo	! ii
	  write(ipost,'(a)') '// node-number value ...'
	  write(ipost,'(a)') '$EndNodeData'
	  write(ipost,*)
	enddo	! s
! nodal flux, j
! calculate w = C for ADE or w = I for EXP
	do s = 1, Ns
	  if(Np .eq. 0)	then
	    w = C					! use matrix form
	  else
	    do ii = 1, Nn
	      w(ii,s) = Ao(ii)*C(ii,s)		! Ao*C(ii)
	      do p = 1, Np
	        w(ii,s) = w(ii,s) + In(ii,s,p)		! sum In(ii,s,p) for node ii
	      enddo	! p
	    enddo	! ii
	  endif
! compute and write {j} = [F]{w}
	  write(ipost,'(a)') '$NodeData'
	  write(ipost,'(i10, a)') 1, '	// number-of-string-tags'
	  write(ipost,'(a2,i1,a)') '"j', s , '" // < "string-tag" > ...'
	  write(ipost,'(i10, a)') 1, '	// number-of-real-tags'
	  write(ipost,'(g, a)') time, '	// < real-tag > ... time'
	  write(ipost,'(i10, a)') 3, '	// number-of-integer-tags'
	  write(ipost,'(i10, a)') Nc, '	// step #'
	  write(ipost,'(i10, a)') 3, '	// number of components'
	  write(ipost,'(i10, a)') Nn, '	// number of nodes'
! compute {work(   1:  Nn)} = [F1]{w} using AMUX from SPARSKIT2
! compute {work(Nn+1:2*Nn)} = [F2]{w} using AMUX from SPARSKIT2
	  call AMUX(Nn, w(1,s), work(   1), vF1, cF1, rF1)	! {work(   1:  Nn)} = [F1]{w}
	  call AMUX(Nn, w(1,s), work(Nn+1), vF2, cF2, rF2)	! {work(Nn+1:2*Nn)} = [F2]{w}
	  do ii = 1, Nn
	    write(ipost,'(i10, 3g)') ii, work(ii), work(Nn+ii), 0.
	  enddo		! ii
	  write(ipost,'(a)') '// node-number value ...'
	  write(ipost,'(a)') '$EndNodeData'
	   write(ipost,*)
	enddo		! s

	return
	end

